/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_LASER_API_
#define SPICE3_LASER_API_

#include "rlTypes.h"

RL_C_API rlResult rlLaserInitConfig(rlLaserConfig* config);
RL_C_API rlResult rlLaserToStringConfig(const rlLaserConfig* config, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlLaserLoadConfig(rlHandle handle);
RL_C_API rlResult rlLaserStoreConfig(rlHandle handle);
RL_C_API rlResult rlLaserGetConfig(rlHandle handle, rlLaserConfig* config);
RL_C_API rlResult rlLaserSetConfig(rlHandle handle, const rlLaserConfig* config);

RL_C_API rlResult rlLaserCreatePowerCalibration(rlHandle handle, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlLaserLoadPowerCalibration(rlHandle handle, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlLaserStorePowerCalibration(rlHandle handle, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlLaserGetPowerCalibration(
    rlHandle handle, rlPowerChannels powerTargetChannel, uint32_t* buffer, int32_t bufferSize, int32_t* calibrationValuesCount);
RL_C_API rlResult rlLaserSetPowerCalibration(
    rlHandle handle, rlPowerChannels powerTargetChannel, const uint32_t* calibrationValues, int32_t calibrationValuesLength);
RL_C_API rlResult rlLaserPowerCalibrationSet(rlHandle handle, rlPowerChannels powerTargetChannel, const char* localFileName);
RL_C_API rlResult rlLaserPowerCalibrationGet(rlHandle handle, rlPowerChannels powerTargetChannel, const char* localFileName);

RL_C_API rlResult rlLaserIsPilotEnabled(rlHandle handle, bool* enabled);
RL_C_API rlResult rlLaserEnablePilot(rlHandle handle, bool enable);

RL_C_API rlResult rlLaserIsLaserArmed(rlHandle handle, bool* armed);
RL_C_API rlResult rlLaserArmLaser(rlHandle handle, bool arm);

RL_C_API rlResult rlLaserReadLaserStatus(rlHandle handle, rlLaserStatus* laserStatus);

RL_C_API rlResult rlLaserGetPowerScale(rlHandle handle, rlPowerChannels powerTargetChannel, double* out);
RL_C_API rlResult rlLaserSetPowerScale(rlHandle handle, rlPowerChannels powerTargetChannel, double scale);

RL_C_API rlResult rlLaserLaserOn(rlHandle handle);
RL_C_API rlResult rlLaserLaserOff(rlHandle handle);

#endif // SPICE3_LASER_API_
